<?php 
require("../../sy-config.php");
session_start();
header("Expires: Mon, 26 Jul 1990 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header('Content-Type: text/html; charset=utf-8');
ob_start(); 
ini_set('display_errors', 1);
require $setup['path']."/".$setup['inc_folder']."/functions.php";
require $setup['path']."/".$setup['inc_folder']."/store/store_functions.php";
require $setup['path']."/".$setup['inc_folder']."/photos_functions.php";
$dbcon = dbConnect($setup);
$site_setup = doSQL("ms_settings", "*", "");
require $setup['path']."/".$setup['inc_folder']."/php-8-adjustments.php"; 

if($site_setup['error_reporting'] == "1") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING ^ E_DEPRECATED);
} else if($site_setup['error_reporting'] == "2") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
} else if($site_setup['error_reporting'] == "3") { 
	error_reporting(E_ALL ^ E_NOTICE);
} else if($site_setup['error_reporting'] == "4") { 
	error_reporting(E_ALL);
} else { 
	error_reporting(0);
}
$store = doSQL("ms_store_settings", "*", "");
date_default_timezone_set(''.$site_setup['time_zone'].'');
$lang = doSQL("ms_language", "*", "");
foreach($lang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}
$storelang = doSQL("ms_store_language", "*", " ");
foreach($storelang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}

foreach($_REQUEST AS $id => $value) {
	if(!empty($value)) { 
		if(!is_array($value)) { 
			$_REQUEST[$id] = addslashes(stripslashes(strip_tags($value)));
			$_REQUEST[$id] = sql_safe("".$_REQUEST[$id]."");
		}
	}
}
ini_set('upload_max_filesize', "400M");
ini_set('post_max_size', "400M");
ini_set('max_execution_time',300);
set_time_limit(300);

function ResizeImage($imagex,$maxwidth,$maxheight,$name, $photo_setup, $setup) {
	$imagex = imagecreatefromjpeg("$imagex"); 
	$width = imagesx($imagex);
	$height = imagesy($imagex);
	if(($maxwidth && $width > $maxwidth) || ($maxheight && $height > $maxheight)){
		if($maxwidth && $width > $maxwidth){
			$widthratio = $maxwidth/$width;
			$RESIZEWIDTH=true;
		}
		if($maxheight && $height > $maxheight){
			$heightratio = $maxheight/$height;
			$RESIZEHEIGHT=true;
		}
		if($RESIZEWIDTH && $RESIZEHEIGHT){
			if($widthratio < $heightratio){
				$ratio = $widthratio;
			}else{
				$ratio = $heightratio;
			}
		}elseif($RESIZEWIDTH){
			$ratio = $widthratio;
		}elseif($RESIZEHEIGHT){
			$ratio = $heightratio;
		}
    	$newwidth = @ceil($width * $ratio);
        $newheight = @ceil($height * $ratio);
		if(function_exists("imagecopyresampled")){
      		$newim = imagecreatetruecolor($newwidth, $newheight);
      		imagecopyresampled($newim, $imagex, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
		}else{
			$newim = imagecreate($newwidth, $newheight);
      		imagecopyresized($newim, $imagex, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);
		}
		/* Sharpen processed photo */
		$sharpen2 = array(
			array(0.0, -1.0, 0.0),
			array(-1.0, 5.0, -1.0),
			array(0.0, -1.0, 0.0)
		);

   		$sharpen = array(
			array(-1.2, -1, -1.2), 
			array(-1, 20, -1), 
			array(-1.2, -1, -1.2) 
		);

		$divisor = array_sum(array_map('array_sum', $sharpen));
		if(function_exists('imageconvolution')) { 
			if($photo_setup['photo_sharpen'] =="1") { 
				imageconvolution($newim, $sharpen, $divisor, 0);
			}
		}

		ImageJpeg ($newim,$name . "$image_ext", 93);
		ImageDestroy ($newim);
	}else{
		ImageJpeg ($imagex,$name . "$image_ext", 93);
	}
	ImageDestroy ($imagex);
}


class GoodZipArchive extends ZipArchive 
{
	//@author Nicolas Heimann
	public function __construct($a=false, $b=false) { $this->create_func($a, $b);  }
	
	public function create_func($input_folder=false, $output_zip_file=false)
	{
		if($input_folder !== false && $output_zip_file !== false)
		{
			$res = $this->open($output_zip_file, ZipArchive::CREATE);
			if($res === TRUE) 	{ $this->addDir($input_folder, basename($input_folder)); $this->close(); }
			else  				{ echo 'Could not create a zip archive. Contact Admin.'; }
		}
	}
	
    // Add a Dir with Files and Subdirs to the archive
    public function addDir($location, $name) {
        $this->addEmptyDir($name);
        $this->addDirDo($location, $name);
    }

    // Add Files & Dirs to archive 
    private function addDirDo($location, $name) {
        $name .= '/';         $location .= '/';
      // Read all Files in Dir
        $dir = opendir ($location);
        while ($file = readdir($dir))    {
            if ($file == '.' || $file == '..') continue;
          // Rekursiv, If dir: GoodZipArchive::addDir(), else ::File();
            $do = (filetype( $location . $file) == 'dir') ? 'addDir' : 'addFile';
            $this->$do($location . $file, $name . $file);
        }
    } 
}



if($_REQUEST['action'] == "startzip") { 
	if(!empty($_REQUEST['did'])) { 
		$date = doSQL("ms_calendar", "*", "WHERE MD5(date_id)='".$_REQUEST['did']."' ");
		$zip_title_name = $date['date_title'];
	}
	if(!empty($_REQUEST['sid'])) { 
		$sub = doSQL("ms_sub_galleries", "*", "WHERE MD5(sub_id)='".$_REQUEST['sid']."' ");
		if($sub['sub_id'] > 0) { 
			$zip_title_name = $date['date_title']." > ".$sub['sub_name'];
		}
	}
	if(!empty($_REQUEST['order_id'])) { 
		if(!is_numeric($_REQUEST['order_id'])) { die("Invalid order ID"); } 
		if(!ctype_alnum($_REQUEST['order_short_url'])) {  die(""); } 

		$order = doSQL("ms_orders", "*", "WHERE order_id='".$_REQUEST['order_id']."' AND order_short_url='".$_REQUEST['order_short_url']."' ");
		if(empty($order['order_id'])) {
			die("An error has occured, unable to find order");
		}
		if($order['order_archive_table'] == "1") { 
			define('cart_table',"ms_cart_archive");
		} else { 
			define('cart_table',"ms_cart");
		}
		$zip_title_name = "Order #".$order['order_id'];
	}

	if($_REQUEST['dem'] == "org") { 
		$dem = 0;
	} else if(empty($_REQUEST['dem'])) { 
		$dem = 0;
	} else {

		if(!is_numeric($_REQUEST['dem'])) { die("DEM incorrect"); } 
		if($_REQUEST['dem'] > 0) { 
			$dem = $_REQUEST['dem'];
		} else { 
			$dem = 0;
		}
	}


	$vars = "did=".$_REQUEST['did']."&sid=".$_REQUEST['sid']."&favpl=".$_REQUEST['favpl']."&dem=".$_REQUEST['dem']."&prod_id=".$_REQUEST['prod_id']."&view=".$_REQUEST['view']."&gs-bgimage-id-free=".$_REQUEST['gs-bgimage-id-free']."&order_id=".$order['order_id']."&passcode=".$_REQUEST['passcode']."";



	if(!empty($_REQUEST['p_id'])) { 
		$person = doSQL("ms_people", "*", "WHERE MD5(p_id)='".$_SESSION['pid']."' ");
		if($person['p_id'] > 0) { 
			$p_id = $person['p_id'];
		}
	}

	if($_REQUEST['view'] == "favorites") { 
		if($p_id <= 0) { 
			die("view favorites, no account ID");
		}
		$zip_favorites = $p_id;
	}

	$zip_folder = trim($site_setup['website_title']);
	$zip_folder = str_replace(' ', '-', $zip_folder);
	$zip_folder = preg_replace('/[^0-9a-z_A-Z-]/', '', $zip_folder); 

	if($_REQUEST['view'] == "favorites") { 
		$zip_folder .= "-".preg_replace('/[^0-9a-z_A-Z-]/', '*',$person['p_name']."-".$person['p_last_name']."-".$storelang['_my_favorites_']);
	} else if($date['date_id'] > 0) { 
		
		$zip_folder .= "-".preg_replace('/[^0-9a-z_A-Z-]/', '-',$date['date_title']);
	} else if($order['order_id'] > 0) { 

		$zip_folder .= "-order-".$order['order_id'];
	} else if(!empty($_REQUEST['multiorders'])) { 
		$zip_folder .= "-multple-orders";
	} else { 
			$zip_folder = date('Ymdhis');
	}
	$zip_folder = $zip_folder."-".date('y-m-d-h:i:s');

	$zip_name = $zip_folder.".zip";





	if($_REQUEST['copy_limit'] > 0) { 
		if(!is_numeric($_REQUEST['copy_limit'])) { 
			$_REQUEST['copy_limit'] = 40;
		}
		$copy_limit = $_REQUEST['copy_limit'];
	} else { 
		$copy_limit = 40;
	}



	$copy_limit_start = 1;
	$send_to_email = "info@picturespro.com";
	$send_to_name = "Testing Tim";


	$key = MD5(date('Ymdhis').$site_setup['salt'].rand(0,1000));

	if(($_REQUEST['zip_admin_order'] == "1") && (!empty($_SESSION['office_admin_id'])) == true) { 
		$multiorders = $_REQUEST['multiorders'];
		$zip_admin_order = 1;
	} else { 
		$zip_admin_order = 0;
		$multiorders = "";
	}


	$zipid = insertSQL("ms_zip_downloads", "
	zip_key='".$key."', 
	zip_free_gallery='".$date['date_id']."',
	zip_title_name='".addslashes(stripslashes($zip_title_name))."', 
	zip_free_sub='".$sub['sub_id']."',
	zip_free_size='".$dem."', 
	date_time_added='".currentdatetime()."', 
	variables='".$vars."', 
	folder='".$zip_folder."', 
	zip_file_name='".$zip_name."' , 
	copy_limit='".$copy_limit."',
	zip_admin_order='".$zip_admin_order."', 
	copy_limit_start='1',
	zip_person='".$p_id."', 
	zip_ip='".getUserIP()."', 
	zip_favorites='".$zip_favorites."', 
	zip_order='".$order['order_id']."', 
	send_to_email='".$send_to_email."',
	zip_multi_orders='".$multiorders."', 
	send_to_name='".addslashes(stripslashes($send_to_name))."' 
	");

	header("location: ".$_SERVER['PHP_SELF']."?zip_key=".$key." ");
	session_write_close();
	exit();
}

if(!empty($_REQUEST['zip_key'])) { 
	if(!ctype_alnum($_REQUEST['zip_key'])) { die("an error has occurred [1]"); }

	$zip = doSQL("ms_zip_downloads", "*", "WHERE zip_key='".$_REQUEST['zip_key']."' ");
	if($_REQUEST['action'] == "cancel") { 
		updateSQL("ms_zip_downloads","zip_cancel='1', all_done='1' WHERE zip_id='".$zip['zip_id']."' ");
		$folder_path = $setup['path']."/".$setup['photos_upload_folder']."/zips/".$zip['folder'];

			$dir = opendir($folder_path); 
			while ($file = readdir($dir)) { 
				if (($file != ".") && ($file != "..")) {
					$file_count++;
					unlink($folder_path."/".$file);

				// print "<li>File: $file";
				}
			}
			closedir($dir); 
			@rmdir($folder_path);


		exit();

	}
} else { 
	exit();
// 	$zip = doSQL("ms_zip_downloads", "*", "WHERE zip_cron='1' AND zip_finished='0' AND all_done='0' ORDER BY zip_id ASC ");
}

if($zip['zip_id'] > 0) { 

	#########################
	# IF copying is done, create zip file
	###########################
	if(($zip['copy_finished'] == "1") && ($zip['zip_finished'] == "1") == true) { 
		die();
	}

	if(($zip['copy_finished'] == "1") && ($zip['zip_started'] == "0") == true) { 

		updateSQL("ms_zip_downloads", "zip_started='1' WHERE zip_id='".$zip['zip_id']."' ");


		$zip_start_time = currentdatetime();
		$bytes = 0;


		$folder_path = $setup['path']."/".$setup['photos_upload_folder']."/zips/".$zip['folder'];
		$zip_path = $setup['path']."/".$setup['photos_upload_folder']."/zips/".$zip['zip_file_name'];
		if(!file_exists($zip_path)) { 


			new GoodZipArchive($folder_path,$zip_path);
			chmod($zip_path, 0644);

			if($zip['zip_admin_order'] > 0) { 
				$expires = date("Y-m-d h:i:s", mktime( date("h"), date("i"), date("s"), date("m"), date("d") + 1, date("Y"))); 
			} else { 
				$expires = date("Y-m-d h:i:s", mktime( date("h"), date("i"), date("s"), date("m"), date("d") + 1, date("Y"))); 
			}
			$zip_size = filesize($zip_path);
			updateSQL("ms_zip_downloads", "zip_finished='1', date_time_completed='".currentdatetime()."', zip_expires='".$expires."', zip_size='".$zip_size."'  WHERE zip_id='".$zip['zip_id']."' ");


			$dir = opendir($folder_path); 
			while ($file = readdir($dir)) { 
				if (($file != ".") && ($file != "..")) {
					$file_count++;
					unlink($folder_path."/".$file);

				// print "<li>File: $file";
				}
			}
			closedir($dir); 
			@rmdir($folder_path);


		$start = new DateTime($zip_start_time);
		$end = new DateTime(currentdatetime());
		$diff = $start->diff($end);

		$daysInSecs = $diff->format('%r%a') * 24 * 60 * 60;
		$hoursInSecs = $diff->h * 60 * 60;
		$minsInSecs = $diff->i * 60;

		$secs = $daysInSecs + $hoursInSecs + $minsInSecs + $diff->s;
		if($secs <= 0) { 
			$secs = 1;
		}
		$bytes_per_second = $zip_size / $secs;

		insertSQL("ms_zip_downloads_time", "zip_id='".$zip['zip_id']."', bytes_per_second='".$bytes_per_second."', remote_storage='0', bytes='".$zip_size."', seconds='".$secs."', zipping='1' ");






			###################################
			# 
			# send email notification
			# 
			##################################

		$message = "<p>Your zip file is ready. <a href=\"".$setup['url'].$setup['temp_url_folder']."/sy-photos/zips/".$zip['zip_file_name']."\">Click here to download</a>.</p>";
		$subject = "Your zip file of photos are ready from ".$site_setup['website_title']."";


			if(empty($em['email_from_email'])) {
			$from_email = $site_setup['contact_email'];
		} else {
			$from_email = $em['email_from_email'];
		}

		if(empty($em['email_from_name'])) {
			$from_name = $site_setup['website_title'];
		} else {
			$from_name = $em['email_from_name'];
		}
		$to_email = $zip['send_to_email'];
		$to_name = $zip['send_to_name'];

		 // sendWebdEmail($to_email, $to_name, $from_email, $from_name, $subject, $message,"1");


		?>zipcomplete|<?php print $zip['zip_key'];?>|100|<?php print showfilesize($zip_size);?>|<A href="<?php print $setup['temp_url_folder'];?>/sy-photos/zips/<?php print $zip['zip_file_name'];?>" download="MyZipFile.zip"><?php print $zip['zip_file_name'];?></a>
		<?php 
		}
		exit();
	}



	$vars = explode("&",$zip['variables']);
	foreach($vars AS $var) { 
		$v = explode("=",$var);
		$_REQUEST[$v[0]] = $v[1];

	}



	$zip_max = $zip['copy_limit'];
	if($zip_max <=0) { 
		$zip_max = 50;
	}



	if($zip['copy_limit_start'] > 0) { 
		$from = ($zip['copy_limit_start'] * $zip_max) -$zip_max;
		$add_sql = "LIMIT ".$from.",".$zip_max." ";
	}

	####################
	# Create folder to copy all files to
	####################
	$parent_permissions = substr(sprintf('%o', fileperms("".$setup['path']."/".$setup['photos_upload_folder']."")), -4); 
	if($parent_permissions == "0755") {
		$perms = 0755;
	} elseif($parent_permissions == "0777") {
		$perms = 0777;
	} else {
		$perms = 0755;
	}



	if(!is_dir("".$setup['path']."/".$setup['photos_upload_folder']."/zips")) {
		mkdir("".$setup['path']."/".$setup['photos_upload_folder']."/zips", $perms);
		chmod("".$setup['path']."/".$setup['photos_upload_folder']."/zips", $perms);
		$fp = fopen("".$setup['path']."/".$setup['photos_upload_folder']."/zips/index.php", "w");
		fputs($fp, "$info\n");
		fclose($fp);
	}


	$new_folder = $zip['folder'];
	$new_folder_path = $setup['path']."/".$setup['photos_upload_folder']."/zips/".$new_folder;
	if(!is_dir("".$setup['path']."/".$setup['photos_upload_folder']."/zips/".$new_folder."")) {
		mkdir("".$setup['path']."/".$setup['photos_upload_folder']."/zips/".$new_folder."", $perms);
		chmod("".$setup['path']."/".$setup['photos_upload_folder']."/zips/".$new_folder."", $perms);
	}




	$wm = doSQL("ms_watermarking", "*", "");
	$date = doSQL("ms_calendar", "*", "WHERE date_id='".$zip['zip_free_gallery']."' ");

	if((empty($date['date_id'])) && ($_REQUEST['view'] !== "favorites") && ($zip['zip_order'] <=0) && (empty($zip['zip_multi_orders'])) == true) {
		die("An error has occured");
	}
	if($_REQUEST['favpl'] > 0) { 
		$date['date_photo_price_list'] = $_REQUEST['favpl'];
	}

	if($_REQUEST['prod_id'] > 0) { 
		if(!is_numeric($_REQUEST['prod_id'])) { die(); } 

		$prod = doSQL("ms_photo_products LEFT JOIN ms_photo_products_connect ON ms_photo_products.pp_id=ms_photo_products_connect.pc_prod", "*", "WHERE pp_id='".$_REQUEST['prod_id']."' ");
	} else { 
		$prod = doSQL("ms_photo_products LEFT JOIN ms_photo_products_connect ON ms_photo_products.pp_id=ms_photo_products_connect.pc_prod", "*", "WHERE pc_list='".$date['date_photo_price_list']."' AND pp_free='1' AND pp_free_all='1' ");
	}

	if($zip['zip_free_sub'] > 0) { 
		$sub = doSQL("ms_sub_galleries", "*", "WHERE MD5(sub_id)='".$_REQUEST['sid']."' ");
	}
	if(isset($_SESSION['pid'])) { 
		$person = doSQL("ms_people", "*", "WHERE MD5(p_id)='".$_SESSION['pid']."' ");
	}







	if((!empty($date['date_id'])) || ($_REQUEST['view'] == "favorites") == true){ 


		if($_REQUEST['view'] == "favorites") { 
			$and_where = "";
			$pics_where = "WHERE MD5(fav_person)='".$_SESSION['pid']."'  AND pic_id>'0'  AND (date_expire='0000-00-00' OR date_expire>='".date('Y-m-d')."'  OR mp_paid_access_expires>='".date('Y-m-d')."')";
			$pics_tables = "ms_favs  LEFT JOIN ms_photos ON ms_favs.fav_pic=ms_photos.pic_id LEFT JOIN ms_calendar ON ms_favs.fav_date_id=ms_calendar.date_id LEFT JOIN ms_my_pages ON ms_calendar.date_id=ms_my_pages.mp_date_id";
			$pics_orderby = "pic_org";
			$person = doSQL("ms_people", "*", "WHERE MD5(p_id)='".$_SESSION['pid']."' ");

		} else { 

			if(!empty($date['date_photo_keywords'])) { 
				$and_date_tag = "( ";
				$date_tags = explode(",",$date['date_photo_keywords']);
				foreach($date_tags AS $tag) { 
					$cx++;
					if($cx > 1) { 
						$and_date_tag .= " OR ";
					}
					$and_date_tag .=" key_key_id='$tag' ";
				}
				$and_date_tag .= " OR bp_blog='".$date['date_id']."' ";
				$and_date_tag .= " ) ";
				
				## NOT DONE NEW DATABASE FIELDS SELECTION ## 
				$pics_where = "WHERE $and_date_tag $and_where  ";
				$pics_tables = "ms_photos LEFT JOIN ms_photo_keywords_connect  ON ms_photos.pic_id=ms_photo_keywords_connect.key_pic_id  LEFT JOIN ms_blog_photos ON ms_photos.pic_id=ms_blog_photos.bp_pic";
				$cx = 0;
			} else { 


				$and_where = getSearchString();
				if(($date['date_owner'] >'0') && ($date['date_owner'] == $person['p_id']) == true) { 
					// Is gallery owner
				} else { 
					$and_where .= " AND pic_hide!='1' ";
				}


				if(!empty($sub['sub_id'])) { 
					$and_sub = "AND bp_sub='".$sub['sub_id']."' ";
				} else { 
					if((empty($_REQUEST['kid']))&&(empty($_REQUEST['keyWord']))==true) { 
						if($zip['zip_admin_order'] <= 0) { 
							// Admin download all photos from a gallery in the admin. 
							$and_sub = "AND bp_sub='0' ";
						}
					} else { 
						if((!empty($_REQUEST['kid']))||(!empty($_REQUEST['keyWord']))==true) { 
							$and_sub = "AND (sub_pass='' OR sub_pass IS NULL)  ";
						}
					}
				}					
				$pics_where = "WHERE bp_blog='".$date['date_id']."' $and_sub ";
				$pics_tables = "ms_blog_photos LEFT JOIN ms_photos ON ms_blog_photos.bp_pic=ms_photos.pic_id LEFT JOIN  ms_photo_keywords_connect ON ms_photos.pic_id=ms_photo_keywords_connect.key_pic_id LEFT JOIN ms_sub_galleries ON ms_blog_photos.bp_sub=ms_sub_galleries.sub_id";
			}
		}



		$pics = whileSQL("$pics_tables", "*, date_format(DATE_ADD(ms_photos.pic_date, INTERVAL 0 HOUR), '%m/%e/%y %h:%i:%s %p ')  AS pic_date, date_format(DATE_ADD(ms_photos.pic_last_viewed, INTERVAL 0 HOUR), '%m/%e/%y %h:%i:%s %p ')  AS pic_last_viewed, date_format(DATE_ADD(ms_photos.pic_date_taken, INTERVAL 0 HOUR), '%m/%e/%y %h:%i:%s %p ')  AS pic_date_taken_show", "$pics_where $and_where AND pic_no_download!='1' GROUP BY pic_id ORDER BY pic_id ASC ");

		$total_pics = mysqli_num_rows($pics);

		if($zip['number_of_files'] <= 0) { 
			updateSQL("ms_zip_downloads", "number_of_files='".$total_pics."', copy_started='1' WHERE zip_id='".$zip['zip_id']."' ");
		} else { 
			$total_pics = $zip['number_of_files'];
		}



		$pics = whileSQL("$pics_tables", "*, date_format(DATE_ADD(ms_photos.pic_date, INTERVAL 0 HOUR), '%m/%e/%y %h:%i:%s %p ')  AS pic_date, date_format(DATE_ADD(ms_photos.pic_last_viewed, INTERVAL 0 HOUR), '%m/%e/%y %h:%i:%s %p ')  AS pic_last_viewed, date_format(DATE_ADD(ms_photos.pic_date_taken, INTERVAL 0 HOUR), '%m/%e/%y %h:%i:%s %p ')  AS pic_date_taken_show", "$pics_where $and_where AND pic_no_download!='1' GROUP BY pic_id  ORDER BY pic_id ASC  $add_sql ");
		//print "<li>".mysqli_num_rows($pics);
	}

	if($zip['zip_order'] > 0) { 
		############################
		# Order Download
		############################# 


		$order = doSQL("ms_orders", "*", "WHERE order_id='".$zip['zip_order']."' ");
		if(empty($order['order_id'])) {
			die("An error has occured");
		}
		if($order['order_archive_table'] == "1") { 
			define('cart_table',"ms_cart_archive");
		} else { 
			define('cart_table',"ms_cart");
		}


		if($zip['zip_admin_order'] == "1") { 
			// Admin order download for ALL photos on order (prints and downloads)

			$pics = whileSQL(cart_table." LEFT JOIN ms_photos ON ".cart_table.".cart_pic_id=ms_photos.pic_id", "*", "WHERE cart_order='".$order['order_id']."'  AND cart_pic_id>'0'   ORDER BY pic_id ASC ");
			$total_pics = mysqli_num_rows($pics);
			if($zip['number_of_files'] <= 0) { 
				updateSQL("ms_zip_downloads", "number_of_files='".$total_pics."', copy_started='1' WHERE zip_id='".$zip['zip_id']."' ");
			} else { 
				$total_pics = $zip['number_of_files'];
			}

			$pics = whileSQL(cart_table." LEFT JOIN ms_photos ON ".cart_table.".cart_pic_id=ms_photos.pic_id", "*", "WHERE cart_order='".$order['order_id']."' AND cart_pic_id>'0'  ORDER BY pic_id ASC  $add_sql ");

			$pics_tables = cart_table." LEFT JOIN ms_photos ON ".cart_table.".cart_pic_id=ms_photos.pic_id";
			$pics_where = "WHERE cart_order='".$order['order_id']."' AND cart_pic_id>'0' ";

		} else { 
			// Customer order download ONLY downloads
			$pics = whileSQL(cart_table." LEFT JOIN ms_photos ON ".cart_table.".cart_pic_id=ms_photos.pic_id", "*", "WHERE cart_order='".$order['order_id']."' AND cart_download='1' AND cart_disable_download<='0' AND cart_pic_id>'0' GROUP BY pic_id ORDER BY pic_id ASC ");
			$total_pics = mysqli_num_rows($pics);
			if($zip['number_of_files'] <= 0) { 
				updateSQL("ms_zip_downloads", "number_of_files='".$total_pics."', copy_started='1' WHERE zip_id='".$zip['zip_id']."' ");
			} else { 
				$total_pics = $zip['number_of_files'];
			}

			$pics = whileSQL(cart_table." LEFT JOIN ms_photos ON ".cart_table.".cart_pic_id=ms_photos.pic_id", "*", "WHERE cart_order='".$order['order_id']."' AND cart_download='1' AND cart_disable_download<='0' AND cart_pic_id>'0' GROUP BY pic_id ORDER BY pic_id ASC  $add_sql ");

			$pics_tables = cart_table." LEFT JOIN ms_photos ON ".cart_table.".cart_pic_id=ms_photos.pic_id";
			$pics_where = "WHERE cart_order='".$order['order_id']."' AND cart_download='1' AND cart_disable_download<='0'  AND cart_pic_id>'0' ";
		}

	}
	

	if(!empty($zip['zip_multi_orders'])) { 
		################################
		# Multiple orders download admin
		#################################
		################ 
		# The query  
		##########################
		$orders = explode("|",$zip['zip_multi_orders']);
		foreach($orders AS $order_id) { 
			if(!empty($order_id)) { 
				$o++;
				if($o > 1) { 
					$or_order .= " OR ";
				}
				$or_order .= "cart_order='".$order_id."'  ";
			}
		}



		if($zip['number_of_files'] <= 0) { 

			$pics = mysqli_query($dbcon,"
			(SELECT * from ms_cart LEFT JOIN ms_photos ON ms_cart.cart_pic_id=ms_photos.pic_id WHERE ($or_order)   AND cart_pic_id>'0' GROUP BY pic_id ORDER BY cart_order ASC, pic_id ASC )
			UNION
			(SELECT * from ms_cart_archive LEFT JOIN ms_photos ON ms_cart_archive.cart_pic_id=ms_photos.pic_id WHERE ($or_order)   AND cart_pic_id>'0' GROUP BY pic_id ORDER BY cart_order ASC, pic_id ASC )

			 ");
			if (!$pics) {	logmysqlerrors(mysqli_error($dbcon));	die("<div class=\"error\">MYSQL ERROR:   " . mysqli_error($dbcon) . " <br><br>Query: SELECT $what FROM $table $where</div>"); }
			$total_pics = mysqli_num_rows($pics);

			updateSQL("ms_zip_downloads", "number_of_files='".$total_pics."', copy_started='1' WHERE zip_id='".$zip['zip_id']."' ");
		} else { 
			$total_pics = $zip['number_of_files'];
		}


		$pics = mysqli_query($dbcon,"
		(SELECT * from ms_cart LEFT JOIN ms_photos ON ms_cart.cart_pic_id=ms_photos.pic_id WHERE ($or_order)   AND cart_pic_id>'0' GROUP BY pic_id ORDER BY cart_order ASC, pic_id ASC )
		UNION
		(SELECT * from ms_cart_archive LEFT JOIN ms_photos ON ms_cart_archive.cart_pic_id=ms_photos.pic_id WHERE ($or_order)   AND cart_pic_id>'0' GROUP BY pic_id ORDER BY cart_order ASC, pic_id ASC  )  $add_sql

		 ");
	
	}

		$cop_start_time = currentdatetime();
		$bytes = 0;

		while($pic = mysqli_fetch_array($pics))  { 
			if(!empty($pic['pic_id'])==true) { 
				$pic_show .= "[pic_id: ".$pic['pic_id']." size: ".$pic['pic_filesize']."] ";
				$gs_bg = "";
				$bytes = $bytes + $pic['pic_filesize'];
				if($pic['pic_amazon'] == "1") { 
					$remote_storage = 1;
				}

				if(!file_exists($new_folder_path."/".$pic['pic_org'])) { 

					$fileNameParts = explode('.', $pic['pic_org'],);
					$ext =  ".".strtolower(end($fileNameParts));

					if($pic['cart_photo_bg'] > 0) {
						$gs_bg = $pic['cart_photo_bg'];
						$gs_where = "WHERE pic_id='".$gs_bg."' ";
					} else { 
						if(!empty($_REQUEST['gs-bgimage-id-free'])) { 
							$gs_bg = $_REQUEST['gs-bgimage-id-free'];
							$gs_where = "WHERE pic_key='".$gs_bg."' ";
						}
					}
						
					if((!empty($gs_bg)) && ($ext == ".png") == true) { 
						// print "<li>green Screen";
						$pic['pic_org'] = str_replace(".png",".jpg",$pic['pic_org']);
						$pic['pic_org'] = str_replace(".PNG",".jpg",$pic['pic_org']);
						$ext = ".jpg";

						$green_screen_cart = true;
						$pic_file_select = "pic_full";
						if($pic['fav_bg_id'] > 0) { 
							$bgphoto = doSQL("ms_photos","*", "$gs_where ");
						} else { 
							$bgphoto = doSQL("ms_photos","*", "$gs_where ");
						}
						require($setup['path']."/sy-inc/gs-photos.php");
						// print "<li>".$image;
						$bg_name = str_replace($ext,"-".$bgphoto['pic_id'].$ext,$pic['pic_org']);

						copy($image, $new_folder_path."/".$bg_name);
						$pic_file = $new_folder_path."/".$bg_name;
						unlink($image);

					} else { 
						// print "<li>NOT green Screen";

						$pic_file = $setup['path']."/".$setup['photos_upload_folder']."/".$pic['pic_folder']."/".$pic['pic_full'];




						if($pic['pic_amazon'] == "1") { 
							if(empty($pic['pic_amazon_endpoint'])) { 
								$endpoint = $site_setup['amazon_endpoint'];
							} else { 
								$endpoint = $pic['pic_amazon_endpoint'];
							}
							if(copy_amazon_file("https://".$endpoint."/".$pic['pic_bucket']."/".$pic['pic_bucket_folder']."/".urlencode($pic['pic_full']),$new_folder_path."/".$pic['pic_org'])) {

								// print "<li>success";
							} else { 
								if(copy("https://".$endpoint."/".$pic['pic_bucket']."/".$pic['pic_bucket_folder']."/".urlencode($pic['pic_full']),$new_folder_path."/".$pic['pic_org'])) { 
								//	print "<li>Copy used";
								}
							}
						}	else { 
							copy($pic_file,$new_folder_path."/".$pic['pic_org']);
						}
						$pic_file = $new_folder_path."/".$pic['pic_org'];
					}



					if(file_exists($pic_file)) { 
						// print "<li>file exists: ".$pic_file; 
						$prod['pp_download_dem'] = $zip['zip_free_size'];
						if($zip['zip_admin_order'] == "1") { 
							$prod['pp_download_dem'] = 0;
							$remove_watermark = 1;
						}

						if($order['order_id'] > 0) { 
							$prod = doSQL("ms_photo_products", "*", "WHERE pp_id='".$pic['cart_photo_prod']."' ");
						}
						if($prod['pp_download_dem'] > 0) { 
							$resized = 1;
							$new_name = str_replace($ext,"-".$prod['pp_download_dem']."".$ext,$pic_file);
							ResizeImage($pic_file,$prod['pp_download_dem'],$prod['pp_download_dem'],$new_name, $photo_setup, $setup);
							unlink($pic_file);
							$pic_file = $new_name;
							$delete_resize = true;
						}

						 if(($prod['pp_free_watermark']=="1")AND((!empty($wm['wm_images_file'])) || (!empty($prod['pp_watermark_file'])))==true) {
							 if($remove_watermark!=="1") {
								$watermarked = 1;
								$size= GetImageSize($pic_file); 

								$iwidth=$size[0];
								$iheight=$size[1];

								$location = $wm['wm_images_location'];
								$overlay = $setup['path']."/".$wm['wm_images_file'];

								if(!empty($prod['pp_watermark_file'])) { 
									$overlay = $setup['path']."/".$prod['pp_watermark_file'];
								}
								if(!empty($prod['pp_watermark_location'])) { 
									$location = $prod['pp_watermark_location'];
								}


								$w_offset = 0;
								$h_offset = 0;
								$overlay = imagecreatefrompng($dir . $overlay);
								 
								// Get the size of overlay
								$owidth = imagesx($overlay);
								$oheight = imagesy($overlay);

						// Changes start here ---------------------------------------------------------

								// if GD library has NOT been used yet ...
								if($new == null)

									// ... load the original image into GD
									$new = imagecreatefromjpeg($pic_file);

						// Changes end here -----------------------------------------------------------
								 if($location == "tile") { 
									imagesettile($new, $overlay);
									imagefilledrectangle($new, -0, 0, $iwidth, $iheight, IMG_COLOR_TILED);
								 } elseif($location == "center") {
									// center
									imagecopy($new, $overlay, ($iwidth / 2) - (($owidth - $w_offset) / 2), ($iheight / 2)- (($oheight - $h_offset)/2), 0, 0, $owidth, $oheight);
								 } elseif($location == "bright") {
								   // bottom right
									imagecopy($new, $overlay, $iwidth- $owidth - $w_offset, $iheight - $oheight - $h_offset, 0, 0, $owidth, $oheight);
								 } elseif($location == "bottom") {
									// bottom center
									imagecopy($new, $overlay, ($iwidth / 2) - (($owidth - $w_offset) / 2), $iheight - $oheight - $h_offset, 0, 0, $owidth, $oheight);
								 } elseif($location == "bleft") {
									// bottom left
									imagecopy($new, $overlay, 0, $iheight - $oheight - $h_offset, 0, 0, $owidth, $oheight);

								 } elseif($location == "uright") {
								   // top right
									imagecopy($new, $overlay, $iwidth- $owidth - $w_offset, 0, 0, 0, $owidth, $oheight);
								 } elseif($location == "top") {
									// top center
									imagecopy($new, $overlay, ($iwidth / 2) - (($owidth - $w_offset) / 2), 0, 0, 0, $owidth, $oheight);
								 } elseif($location == "uleft") {
									// top left
									imagecopy($new, $overlay, 0, 0, 0, 0, $owidth, $oheight);
								 } else {
									imagecopy($new, $overlay, ($iwidth / 2) - (($owidth - $w_offset) / 2), ($iheight / 2)- (($oheight - $h_offset)/2), 0, 0, $owidth, $oheight);
								 }
								imagedestroy($overlay);
								 $wm_tmp = $setup['path']."/".$setup['photos_upload_folder']."/".date('ymdhi').$pic['pic_org'];
				
								imageJPEG($new,$pic_file, 95);
								unset($new);
							 }
						 }

						 // Adding a logo

						if(($prod['pp_free_logo']=="1")AND((!empty($wm['wm_logo_file'])) || (!empty($prod['pp_logo_file'])))==true) {
							$size= GetImageSize($pic_file); 

							$iwidth=$size[0];
							$iheight=$size[1];
							 $location = $wm['wm_add_logo_location'];
							$overlay =$setup['path']."/".$wm['wm_logo_file'];

							if(!empty($prod['pp_logo_file'])) { 
								$overlay = $setup['path']."/".$prod['pp_logo_file'];
							}
							if(!empty($prod['pp_logo_location'])) { 
								$location = $prod['pp_logo_location'];
							}

							$w_offset = 0;
							$h_offset = 0;
							$overlay = imagecreatefrompng($dir . $overlay);
							$owidth = imagesx($overlay);
							$oheight = imagesy($overlay);

						// Changes start here ---------------------------------------------------------

							// ... if GD library has NOT been used yet ...
							if($new == null)

								// ... load the original image into GD
								$new = imagecreatefromjpeg($pic_file);

						// Changes end here -----------------------------------------------------------

							 if($location == "center") {
								// center
								imagecopy($new, $overlay, ($iwidth / 2) - (($owidth - $w_offset) / 2), ($iheight / 2)- (($oheight - $h_offset)/2), 0, 0, $owidth, $oheight);
							 } elseif($location == "bright") {
							   // bottom right
								imagecopy($new, $overlay, $iwidth- $owidth - $w_offset, $iheight - $oheight - $h_offset, 0, 0, $owidth, $oheight);
							 } elseif($location == "bottom") {
								// bottom center
								imagecopy($new, $overlay, ($iwidth / 2) - (($owidth - $w_offset) / 2), $iheight - $oheight - $h_offset, 0, 0, $owidth, $oheight);
							 } elseif($location == "bleft") {
								// bottom left
								imagecopy($new, $overlay, 0, $iheight - $oheight - $h_offset, 0, 0, $owidth, $oheight);

							 } elseif($location == "uright") {
							   // top right
								imagecopy($new, $overlay, $iwidth- $owidth - $w_offset, 0, 0, 0, $owidth, $oheight);
							 } elseif($location == "top") {
								// top center
								imagecopy($new, $overlay, ($iwidth / 2) - (($owidth - $w_offset) / 2), 0, 0, 0, $owidth, $oheight);
							 } elseif($location == "uleft") {
								// top left
								imagecopy($new, $overlay, 0, 0, 0, 0, $owidth, $oheight);
							 } else {
								imagecopy($new, $overlay, ($iwidth / 2) - (($owidth - $w_offset) / 2), ($iheight / 2)- (($oheight - $h_offset)/2), 0, 0, $owidth, $oheight);
							 }
							imagedestroy($overlay);
							 $logo_tmp = $setup['path']."/".$setup['photos_upload_folder']."/l-".date('ymdhi').$pic['pic_org'];

							imageJPEG($new,$pic_file, 95);
							unset($new);

						 }



						if(file_exists($pic_file)) { 

							$pic_count++;
							if($zip['zip_admin_order'] !== "1") { 
								if($order['order_id'] > 0) { 
									$date_id = $pic['cart_pic_date_id'];

									$download_log = date('M d, Y h:i A')."|".getUserIP()." (ZIP)\r\n".$pic['cart_download_log'];
									updateSQL(cart_table, "cart_download_date='".date('Y-m-d H:i:s')."',  cart_download_log='".$download_log."', cart_download_ip='".getUserIP()."'  WHERE cart_id='".$pic['cart_id']."'  ");
								} else if($pic['date_id'] > 0) { 
									$date_id = $pic['date_id'];
								} else { 
									$date_id = $date['date_id'];
								}
								insertSQL("ms_free_downloads", "free_pic='".$pic['pic_id']."', free_date='".date('Y-m-d H:i:s')."', free_date_id='".$date_id."', free_prod='".$prod['pp_id']."', free_person='".$person['p_id']."', free_ip='".getUserIP()."', free_zip='1', zip_download_id='".$zip['zip_id']."', order_id='".$order['order_id']."'   ");

							}
						}
					}
				}
			}
		}

		

		$start = new DateTime($cop_start_time);
		$end = new DateTime(currentdatetime());
		$diff = $start->diff($end);

		$daysInSecs = $diff->format('%r%a') * 24 * 60 * 60;
		$hoursInSecs = $diff->h * 60 * 60;
		$minsInSecs = $diff->i * 60;

		$secs = $daysInSecs + $hoursInSecs + $minsInSecs + $diff->s;
		if($secs <= 0 ) { 
			$secs = 1;
		}
		$bytes_per_second = $bytes / $secs;
		insertSQL("ms_zip_downloads_time", "zip_id='".$zip['zip_id']."', bytes_per_second='".$bytes_per_second."', remote_storage='".$remote_storage."', bytes='".$bytes."', seconds='".$secs."', resized='".$resized."', watermarked='".$watermarked."' ");


		if(!empty($zip['zip_multi_orders'])) { 
			$pics = mysqli_query($dbcon,"
			SELECT SUM(size) FROM (
			(SELECT *, SUM(pic_filesize) AS size from ms_cart LEFT JOIN ms_photos ON ms_cart.cart_pic_id=ms_photos.pic_id WHERE ($or_order)   AND cart_pic_id>'0' GROUP BY pic_id ORDER BY cart_order ASC, pic_id ASC )
			UNION
			(SELECT *, SUM(pic_filesize) AS size from ms_cart_archive LEFT JOIN ms_photos ON ms_cart_archive.cart_pic_id=ms_photos.pic_id WHERE ($or_order)   AND cart_pic_id>'0' GROUP BY pic_id ORDER BY cart_order ASC, pic_id ASC ) ) t1

			 ");
			
			if (!$pics) {	logmysqlerrors(mysqli_error($dbcon));	die("<div class=\"error\">MYSQL ERROR:   " . mysqli_error($dbcon) . " <br><br>Query: SELECT $what FROM $table $where</div>"); }

			$output = mysqli_fetch_array($pics);
			$totalfilesize['size'] = $output[0];


			$pics = mysqli_query($dbcon,"
			SELECT SUM(size) FROM (
			(SELECT *, SUM(pic_filesize) AS size from ms_cart LEFT JOIN ms_photos ON ms_cart.cart_pic_id=ms_photos.pic_id WHERE ($or_order)   AND cart_pic_id>'0' GROUP BY pic_id ORDER BY cart_order ASC, pic_id ASC )
			UNION
			(SELECT *, SUM(pic_filesize) AS size from ms_cart_archive LEFT JOIN ms_photos ON ms_cart_archive.cart_pic_id=ms_photos.pic_id WHERE ($or_order)   AND cart_pic_id>'0' GROUP BY pic_id ORDER BY cart_order ASC, pic_id ASC ) LIMIT ".$zip['copy_limit_start'] * $zip['copy_limit']." ) t1

			 ");
			
			if (!$pics) {	logmysqlerrors(mysqli_error($dbcon));	die("<div class=\"error\">MYSQL ERROR:   " . mysqli_error($dbcon) . " <br><br>Query: SELECT $what FROM $table $where</div>"); }

			$output = mysqli_fetch_array($pics);
			$sum = $output[0];


		} else { 

			$totalfilesize = doSQL("$pics_tables", "*, SUM(pic_filesize) AS size", "$pics_where $and_where AND pic_no_download!='1'    ORDER BY pic_id ASC  ");
			
			$filesize = whileSQL("$pics_tables", "*", "$pics_where $and_where AND pic_no_download!='1'    ORDER BY pic_id ASC  LIMIT ".$zip['copy_limit_start'] * $zip['copy_limit']." "); 
			while($f = mysqli_fetch_array($filesize)) { 
				$sum = $f['pic_filesize'] + $sum;
			}
			// print "SUM: ".$sum." <br><br>query: ".$pics_where." ".$and_where." ".$zip['copy_limit_start']." * ". $zip['copy_limit']."<br><br> pic show: ".$pic_show;

		}





		if($total_pics > ($zip['copy_limit_start'] * $zip['copy_limit'])) { 
			$copy_limit_start = $zip['copy_limit_start'] + 1;
			updateSQL("ms_zip_downloads", "copy_limit_start='".$copy_limit_start."' WHERE zip_id='".$zip['zip_id']."' ");
			$percentdone = number_format(($sum / $totalfilesize['size']) * 100,2);
		} else { 
			updateSQL("ms_zip_downloads", " copy_finished='1'  WHERE zip_id='".$zip['zip_id']."' ");
			$percentdone = 100;
		}

		$done = $zip['copy_limit_start'] * $zip['copy_limit'];
		if($done > $total_pics) { 
			$done = $total_pics;
		}
		print "reload|".$zip['zip_key']."|".$percentdone."| ".$done."  / ".$total_pics." - ".showfilesize($sum)." of ".showfilesize($totalfilesize['size'])." (".number_format(($sum / $totalfilesize['size']) * 100,2)."%)";



} else { 
	print "Nothing to do at the moment";
}
?>
<?php 
exit();
?>
