<?php
require "../../../../sy-config.php";
session_start();
header("Expires: Mon, 26 Jul 1990 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header('Content-Type: text/html; charset=utf-8');
ob_start(); 
require $setup['path']."/".$setup['inc_folder']."/functions.php";
require $setup['path']."/".$setup['inc_folder']."/store/store_functions.php";
$date = date("D M j G:i:s T Y", time());
$dbloc = "".$setup['pc_db_location']."";
$dbase = "".$setup['pc_db']."";
$dbuser = "".$setup['pc_db_user']."";
$dbpass = "".$setup['pc_db_pass']."";
$path = "".$setup['path']."";
$url = "https://".$_SERVER['HTTP_HOST']."";
$db_user = $setup['pc_db_user'];
$dbcon = @mysqli_connect($setup['pc_db_location'],$db_user,$setup['pc_db_pass'],$setup['pc_db'],$setup['db_port'],$setup['db_socket']);
if (!$dbcon) {	echo( "Unable to connect to the database" .mysqli_error($dbcon));	exit(); }
mysqli_query($dbcon,"SET NAMES 'utf8'");
mysqli_query($dbcon,"SET CHARACTER SET utf8");
mysqli_query($dbcon,"SET COLLATION_CONNECTION = 'utf8_unicode_ci'");
mysqli_query($dbcon,"SET SESSION sql_mode = '' ");
// mysqli_query("SET time_zone = '".$site_setup['time_zone']."'");
if(!empty($setup['lc_time_names'])) { 
	mysqli_query($dbcon,"SET lc_time_names = '".$setup['lc_time_names']."' ");
}

$site_setup = doSQL("ms_settings", "*", "");
require $setup['path']."/".$setup['inc_folder']."/php-8-adjustments.php"; 

if($site_setup['error_reporting'] == "1") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING ^ E_DEPRECATED);
} else if($site_setup['error_reporting'] == "2") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
} else if($site_setup['error_reporting'] == "3") { 
	error_reporting(E_ALL ^ E_NOTICE);
} else if($site_setup['error_reporting'] == "4") { 
	error_reporting(E_ALL);
} else { 
	error_reporting(0);
}
date_default_timezone_set(''.$site_setup['time_zone'].'');
$ms = doSQL("ms_settings", "*", "  ");
$store = doSQL("ms_store_settings", "*", "");
if(!empty($_SESSION['ms_lang'])) {
	$lang = doSQL("ms_language", "*", "WHERE lang_id='".$_SESSION['ms_lang']."' ");
} else {
	$lang = doSQL("ms_language", "*", "WHERE lang_default='1' ");
}
foreach($lang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}
$storelang = doSQL("ms_store_language", "*", " ");
foreach($storelang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}
$glang = doSQL("ms_gift_certificate_language", "*", " ");
foreach($glang AS $id => $val) {
	if(!is_numeric($id)) {
		define($id,$val);
	}
}

$approved = false;

$order_session = $_SESSION['ms_session'];
if((empty($order_session)) && (!empty($data['ms_session'])) == true) { 
	$order_session = $data['ms_session'];
}

/* Checking for empty ms_session variable */





$payinfo = doSQL("ms_payment_options", "*", "WHERE pay_option='square' ");

if (strpos($payinfo['pay_num'],'sandbox') !== false) {
	// Sandbox mode
	$_SESSION['squarehost'] = "https://connect.squareupsandbox.com";
} else { 
	$_SESSION['squarehost'] = "https://connect.squareup.com";
}
require 'autoload.php';

# Replace these values. You probably want to start with your Sandbox credentials
# to start: https://docs.connect.squareup.com/articles/using-sandbox/

# The ID of the business location to associate processed payments with.
# If you're testing things out, use a sandbox location ID.
#
# See [Retrieve your business's locations](https://docs.connect.squareup.com/articles/getting-started/#retrievemerchantprofile)
# for an easy way to get your business's location IDs.
// $location_id = 'CBASENTiYCdXJMa1IhvR8wqbugEgAQ';

# The access token to use in all Connect API requests. Use your *sandbox* access
# token if you're just testing things out.
$access_token = $payinfo['pay_key'];

if(empty($payinfo['pay_square_location'])) { 
	$location_token = "Bearer ".$access_token;
	$location_api = new \SquareConnect\Api\LocationApi();
	$locations =  $location_api->listLocations($access_token);
	$location_id = $locations["locations"][0]["id"];
} else { 
	$location_id = trim($payinfo['pay_square_location']);
}

# Helps ensure this code has been reached via form submission

/*
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
  error_log("Received a non-POST request");
  echo "Request not allowed";
  http_response_code(405);
  return;
}
*/


# Fail if the card form didn't send a value for `nonce` to the server

$request_body = file_get_contents('php://input');
$data = json_decode($request_body,true);

$nonce = $data['sourceId'];
if (is_null($nonce)) {
  echo "Invalid card data";
  http_response_code(422);
  return;
}

$charge_amount = $data['grand_total']*100;
$charge_amount = intval($charge_amount);
// $charge_amount = 100;

$transaction_api = new \SquareConnect\Api\TransactionApi();

$request_body = array (
  "card_nonce" => $nonce,
  "verification_token" => $data['verificationToken'],
  "amount_money" => array (
    "amount" => $charge_amount,
    "currency" => $store['currency']
  ),
  "idempotency_key" => uniqid()
);

# The SDK throws an exception if a Connect endpoint responds with anything besides
# a 200-level HTTP code. This block catches any exceptions that occur from the request.
try {
  $result = $transaction_api->charge($access_token, $location_id, $request_body);

  /*echo "<pre>";
  print_r($result);
  echo "</pre>";
*/
  $approved = true;
$transaction = $result->getTransaction();
$transactionID = $transaction["tenders"][0]["transaction_id"];
$fee = $transaction["tenders"][0]["processing_fee_money"];
$amount = $transaction["tenders"][0]["amount_money"]["amount"];
$card_brand = $transaction["tenders"][0]["card_details"]["card"]["card_brand"];
$last_four = $transaction["tenders"][0]["card_details"]["card"]["last_4"];


/*
print "<h1>id: ".$transactionID."</h1>"; 
 print "<h1>fee: ".$fee."</h1>"; 
print "<h1>brand: ".$card_brand."</h1>"; 
print "<h1>amount: ".$amount."</h1>"; 
print "<h1>4: ".$last_four."</h1>"; 
*/
} catch (\SquareConnect\ApiException $e) {
	$approved = false;

  // echo "Caught exception!<br/>";
  // print_r("<strong>Response body:</strong><br/>");
 //  echo "<pre>"; var_dump($e->getResponseBody()); echo "</pre>";
	$response = $e->getResponseBody();
	$er = $response -> errors;
	$error_detail = $er[0]->detail;


  // echo "<br/><strong>Response headers:</strong><br/>";
  // echo "<pre>"; var_dump($e->getResponseHeaders()); echo "</pre>";

}




if($approved == false) { 

	/* 
	$all_data .= "\r\nREPSONSE FROM POST \r\n";
	foreach($data AS $id => $val) {	
		if(($id!=="creditcardpj")AND($id!=="monthpj")AND($id!=="yearpj")AND($id!=="cvvpj")==true) { 
			$all_data .= "$id: $val\r\n";
		}
	}
	*/
	insertSQL("ms_pay_attempts", "date=NOW(), remote_host='$remote_host', ip='".getUserIP()."', vis_id='".$_SESSION['vid']."', amount='".$data['grand_total']."', card='".$last_four."' , card_brand='".$card_brand."' , response_code='".$response->transaction_id."',  response_message='".addslashes(stripslashes($error_detail))."', name='". addslashes(stripslashes($data['first_name']))." ". addslashes(stripslashes($data['last_name']))." ',  email='".$data['email_address']."', order_number='".$data['order_number']."', country='".$data['country']."', all_data='". addslashes(stripslashes($all_data))."' , declined='1'  ");


	$_SESSION['decline_message'] = _checkout_card_declined_."(".$error_detail .") ";

		if($data['order_id'] > 0) { 
			$link = $setup['temp_url_folder']."/".$site_setup['index_page']."?view=order&new=".$order_id; 
		} else { 
			if(!empty($ge_return_link)) { 
				$link = $setup['temp_url_folder'].$ge_return_link."?view=checkout";
			} else { 
				$link = $setup['temp_url_folder']."/".$site_setup['index_page']."?view=checkout"; 
			}
		}
		$_SESSION['decline_message'] = $error_detail;
		  header('Content-Type: application/json; charset=utf-8');
			$response = array(
				'status' => false,
				'message' => 'Declined',
				'data' => $er,
				'returnLink' => $link
			);
			echo json_encode($response);
	exit();
}

if($approved == true) { 
	// exit();
	$order_total_pay = $data['grand_total'];
	$payment_amount = $data['grand_total'];
	$payment_amout = $order_total_pay;
	$sub_total = $data['sub_total'];
	$order_fees = $fee;
	$currency = $store['currency'];
	$transaction_id = $transactionID;
	$order_ship_amount = $data['shipping_price'];
	$shipping_option = $data['ship_select'];
	$order_tax = $data['tax_price'];
	$tax_percentage = $data['tax_percentage'];
	$vat = $data['vat_price'];
	$vat_percentage = $data['vat_percentage'];
	$taxable_amount = $data['taxable_amount'];
	$order_discount = $data['discount_amount'];
	$order_message  = $data['customer_message'];
	$order_pay_type = $card_brand;
	$order_card_last_four = $last_four;

	$order_payment_status = "Completed";
	$order_pending_reason = $data['pending_reason'];
	$pay_option = "Square";
	$first_name = $data['first_name'];
	$last_name = $data['last_name'];
	$email_address = $data['email_address'];
	$company_name = $data['business_name'];
	$country = $data['country'];
	$city = $data['city'];
	$state = $data['state'];
	$zip = $data['zip'];
	$address_status = $data['address_status'];
	$address = $data['address'];
	$phone = $data['order_phone'];
	$order_session = $order_session;
	$ship_business = $data['ship_business'];
	$ship_first_name = $data['ship_first_name'];
	$ship_last_name =  $data['ship_last_name'];
	$ship_address  = $data['ship_address'];
	$ship_city = $data['ship_city'];
	$ship_state = $data['ship_state'];
	$ship_zip = $data['ship_zip'];
	$ship_country = $data['ship_country'];
	$ip_address = getUserIP();
	$coupon_id = $data['coupon_id'];
	$coupon_name = $data['coupon_name'];
	$credit_amount = $data['credit_amount'];
	$gift_certificate_amount = $data['gift_certificate_amount'];
	$gift_certificate_id = $data['gift_certificate_id'];
	$order_eb_discount = $data['eb_amount'];
	$order_notes = $data['order_notes'];
	$order_phone_consent = $data['phone_consent'];

	$order_extra_field_1 = $data['order_extra_field_1'];
	$order_extra_val_1 = $data['order_extra_val_1'];
	$order_extra_field_2 = $data['order_extra_field_2'];
	$order_extra_val_2 = $data['order_extra_val_2'];
	$order_extra_field_3 = $data['order_extra_field_3'];
	$order_extra_val_3 = $data['order_extra_val_3'];
	$order_extra_field_4 = $data['order_extra_field_4'];
	$order_extra_val_4 = $data['order_extra_val_4'];
	$order_extra_field_5 = $data['order_extra_field_5'];
	$order_extra_val_5 = $data['order_extra_val_5'];


	/* New way of getting customer ID if logged in. Theory: perhaps the session isn't making it to the completed payment page which is causing orders with no products.. Now I have added a form field for the PID */

	if(!empty($data['pid'])) { 

		if(!ctype_alnum($data['pid'])) { die(); } 
		$person = doSQL("ms_people", "*", "WHERE MD5(p_id)='".$data['pid']."' ");
		if($person['p_id'] > 0) { 
			$customer_id = $person['p_id'];
		}
	}


	if((empty($customer_id)) && (!empty($_SESSION['pid'])) == true) { 
		$person = doSQL("ms_people", "*", "WHERE MD5(p_id)='".$_SESSION['pid']."' ");
		$customer_id = $person['p_id'];
	}

	if((is_numeric($data['order_id'])) && ($data['order_id'] > 0) == true) { 
		$order_id = $data['order_id'];
		include $setup['path']."/sy-inc/store/payment/square/payment-invoice-complete.php";
	} else { 
		include $setup['path']."/sy-inc/store/payment/square/payment-checkout-complete.php";
	}

}

?>