<?php 
include "../sy-config.php";
session_start();
header('Content-Type: text/html; charset=utf-8');
header("Cache-control: private"); 
ob_start(); 
require "../".$setup['inc_folder']."/functions.php"; 
require "admin.functions.php"; 
require("admin.icons.php");
require("photos.functions.php");
if(!isset($setup['sytist_hosted'])) {
	$setup['sytist_hosted'] = null;
}

if($setup['sytist_hosted'] == true) { 
	require $setup['path']."/sy-hosted.php";
}
$sytist_store = true;
$dbcon = dbConnect($setup);
$site_setup = doSQL("ms_settings", "*", "");
$photo_setup = doSQL("ms_photo_setup", "*", "");
require $setup['path']."/".$setup['inc_folder']."/php-8-adjustments.php"; 

if($site_setup['error_reporting'] == "1") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING ^ E_DEPRECATED);
} else if($site_setup['error_reporting'] == "2") { 
	error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
} else if($site_setup['error_reporting'] == "3") { 
	error_reporting(E_ALL ^ E_NOTICE);
} else if($site_setup['error_reporting'] == "4") { 
	error_reporting(E_ALL);
} else { 
	error_reporting(0);
}

date_default_timezone_set(''.$site_setup['time_zone'].'');
adminsessionCheck();
if($sytist_store == true) { 
	require $setup['path']."/".$setup['inc_folder']."/store/store_functions.php"; 
	$store = doSQL("ms_store_settings", "*", "");
}

if($_REQUEST['view'] == "test") { 
	$data = array();
	$dates = whileSQL("ms_orders", "order_id,order_total","ORDER BY order_id DESC LIMIT 10");
	foreach($dates AS $date) { 
		$data[] = $date;
	}
echo json_encode($data);
}


if($_REQUEST['view'] == "statsthirty") { 
	$data = array();
	$cd = -30;
	while($cd <= 0) {
		$tomorrow_show  = date("l M d, Y", mktime(0, 0, 0, date("m")  , date("d")+$cd, date("Y")));
		$tomorrow_sql  = date("Y-m-d", mktime(0, 0, 0, date("m")  , date("d")+$cd, date("Y")));

		$visitors = countIt("ms_stats_site_visitors", "WHERE st_date='$tomorrow_sql'  ");
		$pvs = countIt("ms_stats_site_pv", "WHERE pv_date='$tomorrow_sql' ");

		$data[$tomorrow_sql]['date'] = $tomorrow_show;
		$data[$tomorrow_sql]['vis'] = $visitors;
		$data[$tomorrow_sql]['pv'] = $pvs;

		$vis[$tomorrow_show] = $visitors;
		$pv[$tomorrow_show] = $pvs;


		$cd++;
	}
	echo json_encode($data);
	// print_r($total);
	exit();
}

if($_REQUEST['view'] == "statsdow") { 
	$data = array();
	$dd = 1;
	while($dd <= 7) {
		$dow  = date("l", mktime(0, 0, 0, 0 , $dd + 4, 0));

		$tvisitors = countIt("ms_stats_site_visitors", "WHERE  st_date BETWEEN CURDATE() - INTERVAL 28 DAY AND CURDATE() - INTERVAL 1 DAY ");
		$tpvs = countIt("ms_stats_site_pv", "WHERE  pv_date BETWEEN CURDATE() - INTERVAL 28 DAY AND CURDATE() - INTERVAL 1 DAY ");
		
		$visitors = countIt("ms_stats_site_visitors", "WHERE DAYOFWEEK(st_date) = $dd  AND st_date BETWEEN CURDATE() - INTERVAL 28 DAY AND CURDATE() - INTERVAL 1 DAY ");
		$pvs = countIt("ms_stats_site_pv", "WHERE DAYOFWEEK(pv_date) = $dd  AND pv_date BETWEEN CURDATE() - INTERVAL 28 DAY AND CURDATE() - INTERVAL 1 DAY ");


		$data[$dd]['dow'] = $dow;
		$data[$dd]['vis'] = $visitors;
		$data[$dd]['pv'] = $pvs;
		 $dd++;
	}
	echo json_encode($data);
	exit();
}

if($_REQUEST['view'] == "monthytotals") { 
	$data = array();

	$months = 12;
	$year = date('Y');
	$month = 1;

	if(empty($_REQUEST['year'])) { 
		$year = date('Y');
	} else {
		$year = $_REQUEST['year'];
	}
	while($month <= 12) { 
		// $month = sprintf("%02s", $month);
		$num = cal_days_in_month(CAL_GREGORIAN, $month, $year); 

		$thismonth = date('F',mktime(0,0,0,$month,1,$year));

		$stotal = doSQL("ms_orders", "SUM(order_payment) AS tot", "WHERE MONTH(order_payment_date)='".$month."' AND YEAR(order_payment_date)='".$year."' AND order_status<'2'  AND order_payment_status='Completed'"); 
		$sp_stotal = doSQL("ms_payment_schedule", "SUM(payment) AS tot", "WHERE MONTH(payment_date)='".$month."' AND YEAR(payment_date)='".$year."' "); 
		$gtotal = doSQL("ms_orders", "SUM(order_payment) AS tot", "WHERE MONTH(order_payment_date)='".$month."' AND YEAR(order_payment_date)='".$year."'  AND order_payment_status='Completed'"); 
		$rtotal = doSQL("ms_orders", "SUM(order_payment) AS tot", "WHERE MONTH(order_payment_date)='".$month."' AND YEAR(order_payment_date)='".$year."' AND order_status='2'  AND order_payment_status='Completed'"); 
		$extotal = doSQL("ms_expenses", "SUM(exp_amount) AS tot", "WHERE MONTH(exp_date)='".$month."' AND YEAR(exp_date)='".$year."' "); 


		$data[$month]['month'] = $thismonth;
		$data[$month]['salestotal'] = $stotal['tot']+$sp_stotal['tot'];
		$data[$month]['salestotalshow'] = showPrice($stotal['tot']+$sp_stotal['tot']);
		$data[$month]['expensetotal'] = $extotal['tot'];

		$month++;
	}

	echo json_encode($data);
	exit();

}


if($_REQUEST['view'] == "yearlychart") { 
	$data = array();
	$order = doSQL("ms_orders", "*, date_format(order_date, '%Y')  AS year", "WHERE order_status<'2' ORDER BY order_id ASC LIMIT 1 ");
	if(isset($order['year'])) { 
		$year = $order['year'];
	} else { 
		$year = date('Y');
	}
	$last_year = date('Y');
	while($year <= $last_year) { 

		$ytotal = doSQL("ms_orders", "SUM(order_payment) AS tot", "WHERE YEAR(order_payment_date)='".$year."' AND order_status<'2'  AND order_payment_status='Completed'"); 
		$sp_ytotal = doSQL("ms_payment_schedule", "SUM(payment) AS tot", "WHERE YEAR(payment_date)='".$year."' "); 
		$yexptotal = doSQL("ms_expenses", "SUM(exp_amount) AS tot", "WHERE YEAR(exp_date)='".$year."'   "); 
		
		$data[$year]['year'] = $year;
		$data[$year]['total'] = $ytotal['tot'] + $sp_ytotal['tot'];

		$year++;
	}


	echo json_encode($data);
	exit();


}



if($_REQUEST['view'] == "thirtydaysales") { 
	$data = array();
	$cd = -30;
	while($cd <= 0) {
		// $month = sprintf("%02s", $month);
		$date  = date("Y-m-d", mktime(0, 0, 0, date("m")  , date("d") + $cd, date("Y")));
		$dateshow  = date("l M d, Y", mktime(0, 0, 0, date("m")  , date("d") + $cd, date("Y")));

		$stotal = doSQL("ms_orders", "SUM(order_payment) AS tot", "WHERE DATE_FORMAT(order_payment_date, '%Y-%m-%d')='".$date."' AND order_status<'2'  AND order_payment_status='Completed'"); 
		$sp_stotal = doSQL("ms_payment_schedule", "SUM(payment) AS tot", "WHERE DATE_FORMAT(payment_date, '%Y-%m-%d')='".$date."' "); 

		$extotal = doSQL("ms_expenses", "SUM(exp_amount) AS tot", "WHERE DATE_FORMAT(exp_date, '%Y-%m-%d')='".$date."' "); 


		$data[$date]['date'] = $date;
		$data[$date]['dateshow'] = $dateshow;
		$data[$date]['sales'] = $stotal['tot']+$sp_stotal['tot'];
		$data[$date]['expenses'] = $extotal['tot'];

		$cd++;
	}

	echo json_encode($data);
	exit();

}

?>