<?php
namespace paypalcheckout;
require __DIR__ . '/autoload.php';
//1. Import the PayPal SDK client that was created in `Set up Server-Side SDK`.
use PayPalClient;
use PayPalCheckoutSdk\Orders\OrdersGetRequest;
if(($payinfo['test_mode'] == "1") || (	$_SESSION['paypal_checkout_test_mode'] == true) == true) { 
	require_once __DIR__ ."/PayPalCheckoutSdk/PayPalClientSandbox.php";
} else { 
	require_once __DIR__ ."/PayPalCheckoutSdk/PayPalClient.php";
}
// print "<li>".$_POST['paypal_checkout_transaction_id'];

class GetOrder
{

  public static function getOrder($orderId)
  {
    global $setup,$site_setup,$store;
    // Call PayPal to get the transaction details
    $client = PayPalClient::client();
    $response = $client->execute(new OrdersGetRequest($orderId));
	
	// print "Status: ".$response->result->status;

	if($response->result->status == "COMPLETED") { 

		/* Validate this transaction then include orderComplete.php here to create the order if valid. */

		print "<li>Amount: ".$response->result->purchase_units[0]->amount->value." ".$response->result->purchase_units[0]->amount->currency_code;
		$payment_amount = $response->result->purchase_units[0]->amount->value;

		print "<li>Fee: ".$response->result->purchase_units[0]->payments->captures[0]->seller_receivable_breakdown->paypal_fee->value;
		$fee = $response->result->purchase_units[0]->payments->captures[0]->seller_receivable_breakdown->paypal_fee->value;

		print "<li>ID: ".$response->result->purchase_units[0]->payments->captures[0]->id;
		$transactionID = $response->result->purchase_units[0]->payments->captures[0]->id;
		
		$order_pay_type = "PayPal";
			// Need to get real payment type, can't find one. 
		
		/*
			print "<pre>";
			print "Status Code: {$response->statusCode}\n";
			print "Status: {$response->result->status}\n";
			print "Order ID: {$response->result->id}\n";
			print "Intent: {$response->result->intent}\n";
		*/ 

		if($response->result->purchase_units[0]->custom_id > 0) { 
			$order_id = $response->result->purchase_units[0]->custom_id;
			$_REQUEST['order_id'] = $order_id;

			include $setup['path']."/sy-inc/store/payment/paypalcheckout/invoicePaymentComplete.php";
		} else { 
			include $setup['path']."/sy-inc/store/payment/paypalcheckout/paymentComplete.php";
		}
	
	
	} else { 
		/* Do something for pending orders or orders that don't seem complete */
				
	}
	/* 
    foreach($response->result->links as $link)
    {
      print "\t{$link->rel}: {$link->href}\tCall Type: {$link->method}\n";
    }
	*/
    // 4. Save the transaction in your database. Implement logic to save transaction to your database for future reference.
    // print "Gross Amount: {$response->result->purchase_units[0]->amount->currency_code} {$response->result->purchase_units[0]->amount->value}\n";

    // To print the whole response body, uncomment the following line
   echo json_encode($response->result, JSON_PRETTY_PRINT);

  }
}

/**
 *This driver function invokes the getOrder function to retrieve
 *sample order details.
 *
 *To get the correct order ID, this sample uses createOrder to create an order
 *and then uses the newly-created order ID with GetOrder.
 */
  GetOrder::getOrder($_POST['paypal_checkout_transaction_id'], true);



?>