<?php

namespace Sample;

use PayPalCheckoutSdk\Core\PayPalHttpClient;
use PayPalCheckoutSdk\Core\SandboxEnvironment;

ini_set('error_reporting', E_ALL); // or error_reporting(E_ALL);
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');

class PayPalClient
{
    /**
     * Returns PayPal HTTP client instance with environment which has access
     * credentials context. This can be used invoke PayPal API's provided the
     * credentials have the access to do so.
     */
    public static function client()
    {
        return new PayPalHttpClient(self::environment());
    }
    
    /**
     * Setting up and Returns PayPal SDK environment with PayPal Access credentials.
     * For demo purpose, we are using SandboxEnvironment. In production this will be
     * ProductionEnvironment.
     */
    public static function environment()
    {
        $clientId = getenv("CLIENT_ID") ?: "AUJe73vcc17aaEWV1y2LSfmVfGVBxvE3l8X5wQbmQMmxJlqSoatQLwgx7nUgILj8otCw9ecbOARvsmzq";
        $clientSecret = getenv("CLIENT_SECRET") ?: "EJ1NM8n-0CyfkqKpOiMag6BLg9A97kia8-6t_gMm0Xc-gZkm3ibJMMyd4L5zM1L9VlGDw0G4gMAc2bn8";
        return new SandboxEnvironment($clientId, $clientSecret);
    }
}

