 <?php
 ##### REFERENCE ########## 
 # https://www.paypal-community.com/t5/PayPal-Payments-Standard/Smart-Payment-Buttons-why-is-onApprove-transaction-confirmation/td-p/2039393 
 # This to capture payment data: https://developer.paypal.com/docs/api/orders/v2/#orders_capture

 ?>
 <style>
 #paypal-button-container { margin: auto; } 

@media screen and (max-width: 400px) {
 #paypal-button-container {
 width: 100%;
 }
}

@media screen and (min-width: 400px) {
 #paypal-button-container {
 width: 250px;
 }
}

#paypaltransaction { display: none; } 
#paypalbackground { width: 100%; height: 100%; position: fixed; z-index: 999; top: 0; left: 0; background: rgba(0,0,0,.7);} 


.paypalspinner {
	position: fixed;
	z-index: 10;
	top: 50%;
	left: 50%;
	transform: translate(-50%, -50%);
	width: calc(100% - 4rem);
	max-width: 30rem;
	text-align: center;
	padding: 2rem;
	margin: 0 auto;
	background-color: #fff;
	box-shadow: 0 4px 6px rgba(0,0,0,0.3), 0 8px 20px rgba(0,0,0,0.1);
	color: rgba(0,0,0,0.6);
  border-radius: 5px;
  z-index: 1000;
}
.paypalspinner b {
	display: block;
	font-size: 1.4rem;
	margin-bottom: 0.5rem;
	color: rgba(0,0,0,1);
}
.paypal-spinner {
	background:  url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACEAAAAwCAIAAAAQDIQGAAABgmlDQ1BzUkdCIElFQzYxOTY2LTIuMQAAKJF1kc8rRFEUxz8zQyM/olAWFi8NKzRGTaQsRgyFxRjl12bmzbwZNW+83htJtspWUWLj14K/gK2yVopIycrCmtgwPefNqJHMuZ17Pvd77zndey64oxlVtyr8oGdzZiQcUmZm5xTvM5VU0MwArTHVMiamRqKUtY87XE686XJqlT/3r9UkkpYKrirhQdUwc8KjwuMrOcPhbeEmNR1LCJ8Kd5pyQeFbR48X+cXhVJG/HDajkSFwNwgrqV8c/8Vq2tSF5eX49Myy+nMf5yW1yez0lMQ28VYsIoQJoTDGMEME6aFf5iBdBOiWFWXy/YX8SZYkV5XZYBWTRVKkydEp6rJUT0rURE/KyLDq9P9vXy2tN1CsXhuCyifbfmsH7xbkN23789C280fgeYSLbCl/6QD63kXfLGm+fahfh7PLkhbfgfMNaHkwYmasIHnE3ZoGrydQNwuN11A9X+zZzz7H9xBdk6+6gt096JDz9QvfkNRn+SCyap4AAAIjSURBVFiF7ddNy6JAAMDxGbPRSbEw69ALBV07yUPQyzfo8/YBgrpEeAo6BQW9J2SiqanNHrwsuz6ltcHu4v/my8wPREYHEkLAs3Rd32w2qqoahnG/3ymK4nlekqRyuSwIwtPh8LFhWdZsNjsejwAAnucFQUAI3W43XdcNwwAAFIvFZrOJMX7ROJ1OiqL4vl+r1er1OsdxP181TXO5XK5Wq1QqJctyoVCIbaiqOplMGIb5+vrKZrPfjb9cLtPp1HGcVqslSVLoPVToWdu2FUVBCHU6nQcAACCbzXY6HYSQoii2bccw5vO567qyLD9+0EEYY1mWXdedz+dRDcuyttttqVQSRfEpECSKYqlU2m63lmVFMna7HQCgWq1GBIKC+4Oxz43z+UzTdD6fj2Xk83maps/ncyTjer1ijCGEsQwIIcb4er1GMjzPQwjFAoIQQp7nRTKirC7fFTo2/N39syVGYnwiSAhRVXWxWJimGZyybRtCyDBM3LkcxyGEsCwbHHIc12g0JEmCmqaNx+N0Op3L5YL1wzRNiqKirOq/ZFnW/X4PPpeEEE3TXNftdrv0fr8nhLTbbZ7n4076OMMwhsPhfr+nfN8HALzwZJ4WzOn7/v/yXiXGP24MBoOPGy+UGInxVxj9fv/jxgslRmJ8xAh+6w6Hwzvbp98jhBwOBwAAy7LQcZzRaBS6r34/jHGv14OEEM/z1ut16Jb0nTKZTKVSoWn6B1Wj9lslFHzfAAAAAElFTkSuQmCC') center center no-repeat;
 center center no-repeat;
}
.paypal-spinner .loading {
	position: relative;
	height: 110px;
	width: 110px;
	left: 50%;
	margin-left: -55px;
	margin-bottom: 2rem;
	border-width: 5px;
	border-style: solid;
	border-color: #2180c0 #ccc #ccc;
	border-radius: 100%;
	animation: rotation .7s infinite linear;
}
@keyframes rotation {
  from { transform: rotate(0deg)   } 
  to   { transform: rotate(359deg) }
}


</style>
<?php $payinfo = doSQL("ms_payment_options", "*", "WHERE pay_option='paypalcheckout' ");  

if ($payinfo['test_mode'] == "1") {
	$_SESSION['paypal_checkout_test_mode'] = true;
} else { 
	$_SESSION['paypal_checkout_test_mode'] = false;
}
?>
<div id="paypalcheckout"  class="payoption" <?php if($default !== "paypalcheckout") { ?>style="display: none;"<?php } ?>>

	<div id="paypaltransaction">
		<div id="paypalbackground"></div>
		<div class="paypalspinner" id="paypal-loading-background">
		<div class="paypal-spinner"><div class="loading"></div></div>
		<?php print $payinfo['paypal_checkout_transaction_message'];?>

		</div>
	</div>
	<?php if(!empty($payinfo['pay_description'])) { ?>
		<div class="pc" style="margin: -6px 0px 12px 0px;"><?php print nl2br($payinfo['pay_description']);?></div>
		<?php } ?>


	 <?php 
	 $disable_funding = "";
	 if(($payinfo['paypal_checkout_disable_credit'] == "1") || ($payinfo['paypal_checkout_disable_card'] == "1") == true) { 
		
		$disable_funding = "&disable-funding=";
		if($payinfo['paypal_checkout_disable_credit'] == "1") { 
			$disable_funding .= "credit,";
		}
		if($payinfo['paypal_checkout_disable_card'] == "1") { 
			$disable_funding .= "card,";
		}
			$disable_funding = rtrim($disable_funding, ',');
	 }
	 ?>

		<script src="https://www.paypal.com/sdk/js?client-id=<?php print $payinfo['pay_num'];?>&currency=<?php print $store['currency'];?><?php print $disable_funding;?>"> // Replace YOUR_SB_CLIENT_ID with your sandbox client ID
		</script>
		<div id="paypal-button-container"></div>

		<!-- Add the checkout buttons, set up the order and approve the order -->


		<!-- We need to pass the session ID or client ID with the payment to use to create the order with --> 


		<script>
		  paypal.Buttons({
				style: {
					color:  '<?php print $payinfo['paypal_checkout_color'];?>',
					shape:  '<?php print $payinfo['paypal_checkout_shape'];?>',
					label:  'pay'
				},
			  createOrder: function(data, actions) {
				  var myOrder = {
					purchase_units: [{
						amount: {
							value: $("#grand_total").val(),
							currency_code: '<?php print $store['currency'];?>'
						},
						description: "<?php print $setup['url'];?> | "+$("#first_name").val()+" "+$("#last_name").val()+" "+$("#email_address").val(),
						custom_id: $("#order_id").val()

					}],
					"application_context" : { 
						 "shipping_preference":"NO_SHIPPING"
					},
					payer: {
						name: {
							given_name: $("#first_name").val(),
							surname: $("#last_name").val()
						},
						email_address: $("#email_address").val(),
					},
				  };
				
				/*
				var country = $("#country").val();
				var address = $("#address").val();
				if(address) myOrder.payer = {
					address: {
						address_line_1: address,
							country_code: 'US',
							postal_code: $("#zip").val()
					}
				};
				*/
				/* 
				var phone = $("#order_phone").val();
				if(phone) myOrder.payer.phone = {
					phone_number: {
						national_number: phone
					}
				};
				*/


			  return actions.order.create(myOrder);
			},

			onCancel: function(data, actions) {
				$("#paypaltransaction").fadeOut(200);
			},

			onError: function(err) {
				alert("I'm sorry, but there appears to be an error. "+err);
			 // console.log("PayPal is a bummer!");
			}, 
			onApprove: function(data) {
				setTimeout(function() { 
					$("#paypaltransaction").fadeIn(200);
				}, 100);
				//  alert(data.orderID);
				return fetch(tempfolder+'/sy-inc/store/payment/paypalcheckout/captureOrder.php?orderId='+data.orderID, {
				method: 'post',
				headers: {
				  'content-type': 'application/json'
				},
				body: JSON.stringify({
				  orderId: data.orderID
				})

			  }).then(function(res) {
				return res.json();
			  }).then(function(details) {
				  $("#paypal_checkout_transaction_id").val(details.id);

				  $("#paypalcheckout-button").click();
				// alert('Transaction funds captured from ' + details.id);
				// alert(details);
			  })
			}
		  }).render('#paypal-button-container'); // Display payment options on your web page
		</script>



	<!-- Create order function previously working: 

			createOrder: function(data, actions) {
				return fetch(tempfolder+'/sy-inc/store/payment/paypalcheckout/createOrder.php?amount='+$("#grand_total").val()+"&currency=<?php print $store['currency'];?>&storeURL=<?php print $setup['url'].$setup['temp_url_folder'];?>", {
					method: 'post'
				}).then(function(res) {
					return res.json();
				}).then(function(orderData) {
					// alert(orderData.id);
					return orderData.id;
				});
			},
	-->

		<?php ### Add hidden fields to post with the successful payment like a credit card payment ### ?>

		<input type="hidden" size="30" name="paypal_checkout_transaction_id" id="paypal_checkout_transaction_id" placeholder="PayPal Checkout Transaction Id"> 
		<input type="hidden" size="30" name="paypal_checkout_status" id="paypal_checkout_status" placeholder="Status PayPal Checkout"> 


	<div class="pc center" id="cardSubmit-paypalcheckout">
		<div class="hide"><button type="submit" name="continueCheckout" onClick="return checkForm('paypalcheckout','<?php print $store['require_terms_conditions'];?>');"  class="checkout hide" id="paypalcheckout-button" style="display:none;">Submit</button></div>

		<?php if($paying_invoice == true) { ?>
		<a href="" onclick="closeSelectPaymentFormOrder(); return false;"><?php print _cancel_;?></a>
		<?php } else { ?>
		<a href="" onClick="editInfo(); return false;">&larr; <?php print _cancel_;?></a>
		<?php } ?>
	</div>

	<div class="pc" id="cardSubmitLoading-anet" style="display: none; height: 50px; ">
		<img src="<?php print $setup['temp_url_folder'];?>/sy-graphics/loading-page.gif" width="160" height="24">
	</div>
	<?php
	if ($payinfo['test_mode'] == "1") {
	?><div class="error">TEST MODE ON - NO PAYMENT WILL BE PROCESSED</div>
	<?php } ?>
</div>
